/*!****************************
 *                            *
 *  Smart Alert 1.2           *
 *                            *
 *  Code: Lukas Prvy          *
 *  Design: Pierre Borodin    *
 *                            *
 ******************************


Usage:

    $.alert.open([type], [title], content, [buttons], [callback]);

    or

    $.alert.open({settings});

Settings:

    container Container for alert placement (optional, 'body')
    type      Alert type('info', 'confirm', 'warning', 'error', 'prompt') (optional, 'info')
    title     Alert title (optional, default title for certain alert type)
    cancel    Show close icon(alert can be then closed also with ESC) (optional, true)
    icon      Set one of icons defined in theme stylesheet or hide icon by setting false (optional, 'info')
    content   Alert content (optional)
    align     Content alignment('left', 'center', 'right') (optional, 'left')
    buttons   Object with buttons {id: 'label', ...} (optional, default buttons for certain alert type or {ok: 'Ok'})
    width     Alert width (optional, 'auto')
    maxHeight Content maximum height (optional, 160)
    draggable Drag&drop(requires jQuery-UI)
    callback  Function that will be called after button press. Parameter value will be pressed
              button id or false in case of closing alert by click on close icon. (optional)
    pie       Determines whether to use PIE.htc directly or use its PHP wrapper('htc', 'php') (optional, 'htc')


Setup:

    $.alert.setup({settings});

Settings:

    defaults           Default alert settings
    defaults.container Default container for alert placement
    defaults.type      Default alert type('info', 'confirm', 'warning', 'error', 'prompt')
    defaults.cancel    Default cancelable setting
    defaults.icon      Default icon setting(icon name or false)
    defaults.content   Default alert content
    defaults.align     Default content alignment('left', 'center', 'right')
    defaults.buttons   Default object with buttons {id: 'label', ...}
    defaults.width     Default alert width
    defaults.maxHeight Default content maximum height
    defaults.draggable Default drag&drop setting
    defaults.callback  Default callback
    defaults.pie       Use PIE.htc directly or use its PHP wrapper('htc', 'php') default setting
    types              Alert types {'typename': {settings}, ...} (optional)

Changelog:

    Version 1.2

    - Maximum height setting
    - Scrollbar

    Version 1.1

    - Compatible with jQuery 1.9+
    - New alert type "prompt"
    - Button cycling

*/

(function(g){var e={defaults:{container:"body",type:"info",title:"&nbsp;",cancel:true,icon:"info",content:"&nbsp;",align:"left",buttons:{ok:"Ok"},active:null,width:"auto",maxHeight:160,draggable:true,callback:g.noop,pie:"htc"},types:{info:{title:"Info",icon:"info",buttons:{ok:"Ok"}},confirm:{title:"Confirm",icon:"confirm",buttons:{yes:"Yes",no:"No"}},warning:{title:"Warning",icon:"warning",buttons:{ok:"Ok"}},error:{title:"Error",icon:"error",buttons:{ok:"Ok"}},prompt:{title:"Prompt",icon:"prompt",buttons:{ok:"Ok",cancel:"Cancel"}}}};var d={};var h=false;var m=g([]);var b=g([]);function i(){var o=["close.png","info.png","confirm.png","warning.png","error.png"];var p=window.devicePixelRatio&&devicePixelRatio==2;o=g.map(o,function(s){return(p?"x2":"img")+"/"+s});var q=g('link[href*="alert/themes/"]');if(!q.length){return}var r=q.attr("href");r=r.substr(0,r.lastIndexOf("/")+1);g.each(o,function(u,t){var s=g("<img />").attr("src",r+t)})}function n(){var p={};if(arguments.length){if(g.isPlainObject(arguments[0])){p=arguments[0]}else{var o=Array.prototype.slice.call(arguments);if(g.isFunction(o[o.length-1])){p.callback=o.pop()}if(g.isPlainObject(o[o.length-1])){p.buttons=o.pop()}if(o.length==3){p.type=o[0];p.title=o[1];p.content=o[2]}else{if(o.length==2){if(e.types[o[0]]){p.type=o[0]}else{p.title=o[0]}p.content=o[1]}else{p.content=o[0]}}}}if(!e.types[p.type]){p.type=e.defaults.type}p=g.extend({},e.defaults,e.types[p.type],p);if(!p.active||!p.buttons[p.active]){for(var q in p.buttons){p.active=q;break}}if(typeof g.fn.draggable=="undefined"){p.draggable=false}p.title=g.trim(p.title)||e.types[p.type].title;if(p.type=="prompt"){p.content+=["<input",'    id="smartAlertPrompt"',p.content?'    class="smartAlertMargin"':"",'    type="text"',"/>"].join("")}return p}function c(){var p=[];g.each(d.buttons,function(s,r){var q=s==d.active?" smartAlertActive":"";p.push(["<div",'    class="smartAlertButton'+q+'"','    data-id="'+s+'"',">",r,"</div>"].join(""))});var o=parseInt(g.browser.version);g(["<div",'    id="smartAlert"','    data-type="'+d.type+'"','    data-cancel="'+d.cancel+'"','    data-icon="'+d.icon+'"','    data-align="'+d.align+'"','    data-draggable="'+d.draggable+'"','    data-pie="'+d.pie+'"',g.browser.chrome?'data-chrome="'+o+'"':"",g.browser.webkit?'data-webkit="'+o+'"':"",g.browser.mozilla?'data-mozilla="'+o+'"':"",g.browser.opera?'data-opera="'+o+'"':"",g.browser.msie?'data-ie="'+o+'"':"",">",'    <div id="smartAlertBox">','        <div id="smartAlertHeader">','            <div id="smartAlertTitle">',d.title,"            </div>",'            <div id="smartAlertClose"></div>',"        </div>",g.browser.msie&&o==7?['        <table id="smartAlertBody">',"            <tbody>","                <tr>",'                    <td id="smartAlertIcon"></td>',"                    <td>",'                        <div id="smartAlertContent">','                            <div id="smartAlertScroll">',d.content,"                            </div>","                        </div>","                    </td>","                </tr>","            </tbody>","        </table>"].join(""):['        <div id="smartAlertBody">','            <div id="smartAlertIcon"></div>','            <div id="smartAlertContent">','                <div id="smartAlertScroll">',d.content,"                </div>","            </div>","        </div>"].join(""),'        <div id="smartAlertButtons">',p.join(""),"        </div>","    </div>","</div>"].join("")).appendTo(d.container);m=g("#smartAlert");b=g("#smartAlertBox");b.width(d.width)}function a(){b.css({top:Math.round(m.height()/2-b.outerHeight()/2-parseInt(b.css("margin-top"))),left:Math.round(m.width()/2-b.outerWidth()/2-parseInt(b.css("margin-left")))})}function f(p){var q=g(".smartAlertButton",m);if(q.length<=1){return true}var o=q.filter(".smartAlertActive");var s=q.length-1;var r=o.index()+p;q.removeClass("smartAlertActive").eq(r>s?0:(r<0?s:r)).addClass("smartAlertActive");return false}function l(o,p){if(!h){return}m.stop(true,true).fadeOut(250,function(){m.remove();h=false;if(g.isFunction(o)){o()}else{d.callback(o||false,p||"")}})}function k(){if(!(g.browser.msie&&g.browser.version<=9)){return}var p=g('link[href*="alert/css/"]');var o=p.attr("href");o=o.substr(0,o.lastIndexOf("/")+1);g("*",m).each(function(){var q=g(this);if(q.css("behavior")!="none"){if(g.browser.version<9){q.css("behavior","none")}q.css("behavior","url("+o+"PIE."+d.pie+")")}})}function j(){i();g(document).on({keydown:function(o){if(h){switch(o.which){case 27:if(d.cancel){l()}break;case 9:return f(1);break;case 13:g(".smartAlertActive",m).addClass("smartAlertClick");break;default:return true}return false}},keyup:function(o){if(h&&o.which==13){g(".smartAlertActive",m).removeClass("smartAlertClick").trigger("click");return false}}}).on("click","#smartAlertClose",function(){l()}).on({mousedown:function(){g(this).addClass("smartAlertClick")},"mouseup mouseleave":function(){g(this).removeClass("smartAlertClick")},click:function(){var p=g(this).data("id");var o=d.type=="prompt"?g("#smartAlertPrompt").val():"";l(p,o)}},".smartAlertButton");g(window).on("resize",function(){if(h&&g(d.container).is("body")){a()}})}jQuery.alert={open:function(){var p=arguments;function o(){d=n.apply(null,p);c();if(d.draggable){b.draggable({containment:"#smartAlert",handle:"#smartAlertHeader"})}m.css("visibility","visible").find("#smartAlertScroll").css("max-height",d.maxHeight).mCustomScrollbar().find(".mCSB_container").attr("id","smartAlertScrollArea").end().find(".mCSB_draggerRail").attr("id","smartAlertScrollBar").end().find(".mCSB_dragger_bar").attr("id","smartAlertScrollDrag");a();m.hide().fadeIn(250,function(){if(d.type=="prompt"){g("#smartAlertPrompt").focus()}});k();h=true}if(h){l(o)}else{o()}},setup:function(o){if(g.isPlainObject(o)){g.extend(true,e,o)}return g.extend(true,{},e)}};if(!jQuery.browser){(function(){var o,p;jQuery.uaMatch=function(r){r=r.toLowerCase();var q=/(chrome)[ \/]([\w.]+)/.exec(r)||/(webkit)[ \/]([\w.]+)/.exec(r)||/(opera)(?:.*version|)[ \/]([\w.]+)/.exec(r)||/(msie) ([\w.]+)/.exec(r)||r.indexOf("compatible")<0&&/(mozilla)(?:.*? rv:([\w.]+)|)/.exec(r)||[];return{browser:q[1]||"",version:q[2]||"0"}};o=jQuery.uaMatch(navigator.userAgent);p={};if(o.browser){p[o.browser]=true;p.version=o.version}if(p.chrome){p.webkit=true}else{if(p.webkit){p.safari=true}}jQuery.browser=p})()}g(j)})(jQuery);(function(f){function g(a){var n=a||window.event,m=[].slice.call(arguments,1),l=0,k=!0,j=0,i=0;return a=f.event.fix(n),a.type="mousewheel",n.wheelDelta&&(l=n.wheelDelta/120),n.detail&&(l=-n.detail/3),i=l,n.axis!==undefined&&n.axis===n.HORIZONTAL_AXIS&&(i=0,j=-1*l),n.wheelDeltaY!==undefined&&(i=n.wheelDeltaY/120),n.wheelDeltaX!==undefined&&(j=-1*n.wheelDeltaX/120),m.unshift(a,l,j,i),(f.event.dispatch||f.event.handle).apply(this,m)}var e=["DOMMouseScroll","mousewheel"];if(f.event.fixHooks){for(var h=e.length;h;){f.event.fixHooks[e[--h]]=f.event.mouseHooks}}f.event.special.mousewheel={setup:function(){if(this.addEventListener){for(var b=e.length;b;){this.addEventListener(e[--b],g,!1)}}else{this.onmousewheel=g}},teardown:function(){if(this.removeEventListener){for(var b=e.length;b;){this.removeEventListener(e[--b],g,!1)}}else{this.onmousewheel=null}}},f.fn.extend({mousewheel:function(b){return b?this.bind("mousewheel",b):this.trigger("mousewheel")},unmousewheel:function(b){return this.unbind("mousewheel",b)}})})(jQuery);(function(h){var e={init:function(b){var a={set_width:false,set_height:false,horizontalScroll:false,scrollInertia:950,mouseWheel:true,mouseWheelPixels:"auto",autoDraggerLength:true,autoHideScrollbar:false,scrollButtons:{enable:false,scrollType:"continuous",scrollSpeed:"auto",scrollAmount:40},advanced:{updateOnBrowserResize:true,updateOnContentResize:false,autoExpandHorizontalScroll:false,autoScrollOnFocus:true,normalizeMouseWheelDelta:false},contentTouchScroll:true,callbacks:{onScrollStart:function(){},onScroll:function(){},onTotalScroll:function(){},onTotalScrollBack:function(){},onTotalScrollOffset:0,onTotalScrollBackOffset:0,whileScrolling:function(){}},theme:"light"},b=h.extend(true,a,b);return this.each(function(){var y=h(this);if(b.set_width){y.css("width",b.set_width)}if(b.set_height){y.css("height",b.set_height)}if(!h(document).data("mCustomScrollbar-index")){h(document).data("mCustomScrollbar-index","1")}else{var G=parseInt(h(document).data("mCustomScrollbar-index"));h(document).data("mCustomScrollbar-index",G+1)}y.wrapInner("<div class='mCustomScrollBox mCS-"+b.theme+"' id='mCSB_"+h(document).data("mCustomScrollbar-index")+"' style='position:relative; height:100%; overflow:hidden; max-width:100%;' />").addClass("mCustomScrollbar _mCS_"+h(document).data("mCustomScrollbar-index"));var E=y.children(".mCustomScrollBox");if(b.horizontalScroll){E.addClass("mCSB_horizontal").wrapInner("<div class='mCSB_h_wrapper' style='position:relative; left:0; width:999999px;' />");var A=E.children(".mCSB_h_wrapper");A.wrapInner("<div class='mCSB_container' style='position:absolute; left:0;' />").children(".mCSB_container").css({width:A.children().outerWidth(),position:"relative"}).unwrap()}else{E.wrapInner("<div class='mCSB_container' style='position:relative; top:0;' />")}var w=E.children(".mCSB_container");if(h.support.touch){w.addClass("mCS_touch")}w.after("<div class='mCSB_scrollTools' style='position:absolute;'><div class='mCSB_draggerContainer'><div class='mCSB_dragger' style='position:absolute;' oncontextmenu='return false;'><div class='mCSB_dragger_bar' style='position:relative;'></div></div><div class='mCSB_draggerRail'></div></div></div>");var z=E.children(".mCSB_scrollTools"),D=z.children(".mCSB_draggerContainer"),d=D.children(".mCSB_dragger");if(b.horizontalScroll){d.data("minDraggerWidth",d.width())}else{d.data("minDraggerHeight",d.height())}if(b.scrollButtons.enable){if(b.horizontalScroll){z.prepend("<a class='mCSB_buttonLeft' oncontextmenu='return false;'></a>").append("<a class='mCSB_buttonRight' oncontextmenu='return false;'></a>")}else{z.prepend("<a class='mCSB_buttonUp' oncontextmenu='return false;'></a>").append("<a class='mCSB_buttonDown' oncontextmenu='return false;'></a>")}}E.bind("scroll",function(){if(!y.is(".mCS_disabled")){E.scrollTop(0).scrollLeft(0)}});y.data({mCS_Init:true,mCustomScrollbarIndex:h(document).data("mCustomScrollbar-index"),horizontalScroll:b.horizontalScroll,scrollInertia:b.scrollInertia,scrollEasing:"mcsEaseOut",mouseWheel:b.mouseWheel,mouseWheelPixels:b.mouseWheelPixels,autoDraggerLength:b.autoDraggerLength,autoHideScrollbar:b.autoHideScrollbar,scrollButtons_enable:b.scrollButtons.enable,scrollButtons_scrollType:b.scrollButtons.scrollType,scrollButtons_scrollSpeed:b.scrollButtons.scrollSpeed,scrollButtons_scrollAmount:b.scrollButtons.scrollAmount,autoExpandHorizontalScroll:b.advanced.autoExpandHorizontalScroll,autoScrollOnFocus:b.advanced.autoScrollOnFocus,normalizeMouseWheelDelta:b.advanced.normalizeMouseWheelDelta,contentTouchScroll:b.contentTouchScroll,onScrollStart_Callback:b.callbacks.onScrollStart,onScroll_Callback:b.callbacks.onScroll,onTotalScroll_Callback:b.callbacks.onTotalScroll,onTotalScrollBack_Callback:b.callbacks.onTotalScrollBack,onTotalScroll_Offset:b.callbacks.onTotalScrollOffset,onTotalScrollBack_Offset:b.callbacks.onTotalScrollBackOffset,whileScrolling_Callback:b.callbacks.whileScrolling,bindEvent_scrollbar_drag:false,bindEvent_content_touch:false,bindEvent_scrollbar_click:false,bindEvent_mousewheel:false,bindEvent_buttonsContinuous_y:false,bindEvent_buttonsContinuous_x:false,bindEvent_buttonsPixels_y:false,bindEvent_buttonsPixels_x:false,bindEvent_focusin:false,bindEvent_autoHideScrollbar:false,mCSB_buttonScrollRight:false,mCSB_buttonScrollLeft:false,mCSB_buttonScrollDown:false,mCSB_buttonScrollUp:false});if(b.horizontalScroll){if(y.css("max-width")!=="none"){if(!b.advanced.updateOnContentResize){b.advanced.updateOnContentResize=true}}}else{if(y.css("max-height")!=="none"){var H=false,c=parseInt(y.css("max-height"));if(y.css("max-height").indexOf("%")>=0){H=c,c=y.parent().height()*H/100}y.css("overflow","hidden");E.css("max-height",c)}}y.mCustomScrollbar("update");if(b.advanced.updateOnBrowserResize){var C,B=h(window).width(),F=h(window).height();h(window).bind("resize."+y.data("mCustomScrollbarIndex"),function(){if(C){clearTimeout(C)}C=setTimeout(function(){if(!y.is(".mCS_disabled")&&!y.is(".mCS_destroyed")){var i=h(window).width(),j=h(window).height();if(B!==i||F!==j){if(y.css("max-height")!=="none"&&H){E.css("max-height",y.parent().height()*H/100)}y.mCustomScrollbar("update");B=i;F=j}}},150)})}if(b.advanced.updateOnContentResize){var v;if(b.horizontalScroll){var x=w.outerWidth()}else{var x=w.outerHeight()}v=setInterval(function(){if(b.horizontalScroll){if(b.advanced.autoExpandHorizontalScroll){w.css({position:"absolute",width:"auto"}).wrap("<div class='mCSB_h_wrapper' style='position:relative; left:0; width:999999px;' />").css({width:w.outerWidth(),position:"relative"}).unwrap()}var i=w.outerWidth()}else{var i=w.outerHeight()}if(i!=x){y.mCustomScrollbar("update");x=i}},300)}})},update:function(){var Q=h(this),T=Q.children(".mCustomScrollBox"),M=T.children(".mCSB_container");M.removeClass("mCS_no_scrollbar");Q.removeClass("mCS_disabled mCS_destroyed");T.scrollTop(0).scrollLeft(0);var b=T.children(".mCSB_scrollTools"),P=b.children(".mCSB_draggerContainer"),R=P.children(".mCSB_dragger");if(Q.data("horizontalScroll")){var O=b.children(".mCSB_buttonLeft"),G=b.children(".mCSB_buttonRight"),Y=T.width();if(Q.data("autoExpandHorizontalScroll")){M.css({position:"absolute",width:"auto"}).wrap("<div class='mCSB_h_wrapper' style='position:relative; left:0; width:999999px;' />").css({width:M.outerWidth(),position:"relative"}).unwrap()}var a=M.outerWidth()}else{var d=b.children(".mCSB_buttonUp"),X=b.children(".mCSB_buttonDown"),K=T.height(),V=M.outerHeight()}if(V>K&&!Q.data("horizontalScroll")){b.css("display","block");var I=P.height();if(Q.data("autoDraggerLength")){var F=Math.round(K/V*I),S=R.data("minDraggerHeight");if(F<=S){R.css({height:S})}else{if(F>=I-10){var N=I-10;R.css({height:N})}else{R.css({height:F})}}R.children(".mCSB_dragger_bar").css({"line-height":R.height()+"px"})}var L=R.height(),c=(V-K)/(I-L);Q.data("scrollAmount",c).mCustomScrollbar("scrolling",T,M,P,R,d,X,O,G);var H=Math.abs(M.position().top);Q.mCustomScrollbar("scrollTo",H,{scrollInertia:0})}else{if(a>Y&&Q.data("horizontalScroll")){b.css("display","block");var W=P.width();if(Q.data("autoDraggerLength")){var U=Math.round(Y/a*W),J=R.data("minDraggerWidth");if(U<=J){R.css({width:J})}else{if(U>=W-10){var Z=W-10;R.css({width:Z})}else{R.css({width:U})}}}var E=R.width(),c=(a-Y)/(W-E);Q.data("scrollAmount",c).mCustomScrollbar("scrolling",T,M,P,R,d,X,O,G);var H=Math.abs(M.position().left);Q.mCustomScrollbar("scrollTo",H,{scrollInertia:0})}else{T.unbind("mousewheel focusin");if(Q.data("horizontalScroll")){R.add(M).css("left",0)}else{R.add(M).css("top",0)}b.css("display","none");M.addClass("mCS_no_scrollbar");Q.data({bindEvent_mousewheel:false,bindEvent_focusin:false})}}},scrolling:function(U,M,P,S,b,X,L,c){var R=h(this);if(!R.data("bindEvent_scrollbar_drag")){var O,N;if(h.support.msPointer){S.bind("MSPointerDown",function(k){k.preventDefault();R.data({on_drag:true});S.addClass("mCSB_dragger_onDrag");var l=h(this),i=l.offset(),m=k.originalEvent.pageX-i.left,j=k.originalEvent.pageY-i.top;if(m<l.width()&&m>0&&j<l.height()&&j>0){O=j;N=m}});h(document).bind("MSPointerMove."+R.data("mCustomScrollbarIndex"),function(k){k.preventDefault();if(R.data("on_drag")){var l=S,i=l.offset(),m=k.originalEvent.pageX-i.left,j=k.originalEvent.pageY-i.top;G(O,N,j,m)}}).bind("MSPointerUp."+R.data("mCustomScrollbarIndex"),function(i){i.preventDefault();R.data({on_drag:false});S.removeClass("mCSB_dragger_onDrag")})}else{S.bind("mousedown touchstart",function(l){l.preventDefault();l.stopImmediatePropagation();var m=h(this),i=m.offset(),n,j;if(l.type==="touchstart"){var k=l.originalEvent.touches[0]||l.originalEvent.changedTouches[0];n=k.pageX-i.left;j=k.pageY-i.top}else{R.data({on_drag:true});S.addClass("mCSB_dragger_onDrag");n=l.pageX-i.left;j=l.pageY-i.top}if(n<m.width()&&n>0&&j<m.height()&&j>0){O=j;N=n}}).bind("touchmove",function(l){l.preventDefault();l.stopImmediatePropagation();var i=l.originalEvent.touches[0]||l.originalEvent.changedTouches[0],m=h(this),j=m.offset(),n=i.pageX-j.left,k=i.pageY-j.top;G(O,N,k,n)});h(document).bind("mousemove."+R.data("mCustomScrollbarIndex"),function(k){k.preventDefault();if(R.data("on_drag")){var l=S,i=l.offset(),m=k.pageX-i.left,j=k.pageY-i.top;G(O,N,j,m)}}).bind("mouseup."+R.data("mCustomScrollbarIndex"),function(i){i.preventDefault();R.data({on_drag:false});S.removeClass("mCSB_dragger_onDrag")})}R.data({bindEvent_scrollbar_drag:true})}function G(k,j,i,l){if(R.data("horizontalScroll")){R.mCustomScrollbar("scrollTo",(S.position().left-(j))+l,{moveDragger:true,trigger:"internal"})}else{R.mCustomScrollbar("scrollTo",(S.position().top-(k))+i,{moveDragger:true,trigger:"internal"})}}if(h.support.touch&&R.data("contentTouchScroll")){if(!R.data("bindEvent_content_touch")){var Q,K,I,F,d,H,y;M.bind("touchstart",function(i){i.stopImmediatePropagation();Q=i.originalEvent.touches[0]||i.originalEvent.changedTouches[0];K=h(this);I=K.offset();d=Q.pageX-I.left;F=Q.pageY-I.top;H=F;y=d});M.bind("touchmove",function(i){i.preventDefault();i.stopImmediatePropagation();Q=i.originalEvent.touches[0]||i.originalEvent.changedTouches[0];K=h(this).parent();I=K.offset();d=Q.pageX-I.left;F=Q.pageY-I.top;if(R.data("horizontalScroll")){R.mCustomScrollbar("scrollTo",y-d,{trigger:"internal"})}else{R.mCustomScrollbar("scrollTo",H-F,{trigger:"internal"})}})}}if(!R.data("bindEvent_scrollbar_click")){P.bind("click",function(j){var i=(j.pageY-P.offset().top)*R.data("scrollAmount"),k=h(j.target);if(R.data("horizontalScroll")){i=(j.pageX-P.offset().left)*R.data("scrollAmount")}if(k.hasClass("mCSB_draggerContainer")||k.hasClass("mCSB_draggerRail")){R.mCustomScrollbar("scrollTo",i,{trigger:"internal",scrollEasing:"draggerRailEase"})}});R.data({bindEvent_scrollbar_click:true})}if(R.data("mouseWheel")){if(!R.data("bindEvent_mousewheel")){U.bind("mousewheel",function(l,j){var m,n=R.data("mouseWheelPixels"),i=Math.abs(M.position().top),k=S.position().top,o=P.height()-S.height();if(R.data("normalizeMouseWheelDelta")){if(j<0){j=-1}else{j=1}}if(n==="auto"){n=100+Math.round(R.data("scrollAmount")/2)}if(R.data("horizontalScroll")){k=S.position().left;o=P.width()-S.width();i=Math.abs(M.position().left)}if((j>0&&k!==0)||(j<0&&k!==o)){l.preventDefault();l.stopImmediatePropagation()}m=i-(j*n);R.mCustomScrollbar("scrollTo",m,{trigger:"internal"})});R.data({bindEvent_mousewheel:true})}}if(R.data("scrollButtons_enable")){if(R.data("scrollButtons_scrollType")==="pixels"){if(R.data("horizontalScroll")){c.add(L).unbind("mousedown touchstart MSPointerDown mouseup MSPointerUp mouseout MSPointerOut touchend",T,V);R.data({bindEvent_buttonsContinuous_x:false});if(!R.data("bindEvent_buttonsPixels_x")){c.bind("click",function(i){i.preventDefault();J(Math.abs(M.position().left)+R.data("scrollButtons_scrollAmount"))});L.bind("click",function(i){i.preventDefault();J(Math.abs(M.position().left)-R.data("scrollButtons_scrollAmount"))});R.data({bindEvent_buttonsPixels_x:true})}}else{X.add(b).unbind("mousedown touchstart MSPointerDown mouseup MSPointerUp mouseout MSPointerOut touchend",T,V);R.data({bindEvent_buttonsContinuous_y:false});if(!R.data("bindEvent_buttonsPixels_y")){X.bind("click",function(i){i.preventDefault();J(Math.abs(M.position().top)+R.data("scrollButtons_scrollAmount"))});b.bind("click",function(i){i.preventDefault();J(Math.abs(M.position().top)-R.data("scrollButtons_scrollAmount"))});R.data({bindEvent_buttonsPixels_y:true})}}function J(i){if(!S.data("preventAction")){S.data("preventAction",true);R.mCustomScrollbar("scrollTo",i,{trigger:"internal"})}}}else{if(R.data("horizontalScroll")){c.add(L).unbind("click");R.data({bindEvent_buttonsPixels_x:false});if(!R.data("bindEvent_buttonsContinuous_x")){c.bind("mousedown touchstart MSPointerDown",function(j){j.preventDefault();var i=a();R.data({mCSB_buttonScrollRight:setInterval(function(){R.mCustomScrollbar("scrollTo",Math.abs(M.position().left)+i,{trigger:"internal",scrollEasing:"easeOutCirc"})},17)})});var T=function(i){i.preventDefault();clearInterval(R.data("mCSB_buttonScrollRight"))};c.bind("mouseup touchend MSPointerUp mouseout MSPointerOut",T);L.bind("mousedown touchstart MSPointerDown",function(j){j.preventDefault();var i=a();R.data({mCSB_buttonScrollLeft:setInterval(function(){R.mCustomScrollbar("scrollTo",Math.abs(M.position().left)-i,{trigger:"internal",scrollEasing:"easeOutCirc"})},17)})});var V=function(i){i.preventDefault();clearInterval(R.data("mCSB_buttonScrollLeft"))};L.bind("mouseup touchend MSPointerUp mouseout MSPointerOut",V);R.data({bindEvent_buttonsContinuous_x:true})}}else{X.add(b).unbind("click");R.data({bindEvent_buttonsPixels_y:false});if(!R.data("bindEvent_buttonsContinuous_y")){X.bind("mousedown touchstart MSPointerDown",function(j){j.preventDefault();var i=a();R.data({mCSB_buttonScrollDown:setInterval(function(){R.mCustomScrollbar("scrollTo",Math.abs(M.position().top)+i,{trigger:"internal",scrollEasing:"easeOutCirc"})},17)})});var x=function(i){i.preventDefault();clearInterval(R.data("mCSB_buttonScrollDown"))};X.bind("mouseup touchend MSPointerUp mouseout MSPointerOut",x);b.bind("mousedown touchstart MSPointerDown",function(j){j.preventDefault();var i=a();R.data({mCSB_buttonScrollUp:setInterval(function(){R.mCustomScrollbar("scrollTo",Math.abs(M.position().top)-i,{trigger:"internal",scrollEasing:"easeOutCirc"})},17)})});var W=function(i){i.preventDefault();clearInterval(R.data("mCSB_buttonScrollUp"))};b.bind("mouseup touchend MSPointerUp mouseout MSPointerOut",W);R.data({bindEvent_buttonsContinuous_y:true})}}function a(){var i=R.data("scrollButtons_scrollSpeed");if(R.data("scrollButtons_scrollSpeed")==="auto"){i=Math.round((R.data("scrollInertia")+100)/40)}return i}}}if(R.data("autoScrollOnFocus")){if(!R.data("bindEvent_focusin")){U.bind("focusin",function(){U.scrollTop(0).scrollLeft(0);var i=h(document.activeElement);if(i.is("input,textarea,select,button,a[tabindex],area,object")){var j=M.position().top,l=i.position().top,k=U.height()-i.outerHeight();if(R.data("horizontalScroll")){j=M.position().left;l=i.position().left;k=U.width()-i.outerWidth()}if(j+l<0||j+l>k){R.mCustomScrollbar("scrollTo",l,{trigger:"internal"})}}});R.data({bindEvent_focusin:true})}}if(R.data("autoHideScrollbar")){if(!R.data("bindEvent_autoHideScrollbar")){U.bind("mouseenter",function(i){U.addClass("mCS-mouse-over");g.showScrollbar.call(U.children(".mCSB_scrollTools"))}).bind("mouseleave touchend",function(i){U.removeClass("mCS-mouse-over");if(i.type==="mouseleave"){g.hideScrollbar.call(U.children(".mCSB_scrollTools"))}});R.data({bindEvent_autoHideScrollbar:true})}}},scrollTo:function(v,F){var a=h(this),y={moveDragger:false,trigger:"external",callbacks:true,scrollInertia:a.data("scrollInertia"),scrollEasing:a.data("scrollEasing")},F=h.extend(y,F),z,A=a.children(".mCustomScrollBox"),H=A.children(".mCSB_container"),b=A.children(".mCSB_scrollTools"),B=b.children(".mCSB_draggerContainer"),G=B.children(".mCSB_dragger"),C=draggerSpeed=F.scrollInertia,w,D,x,E;a.data({mCS_trigger:F.trigger});if(a.data("mCS_Init")){F.callbacks=false}if(v||v===0){if(typeof(v)==="number"){if(F.moveDragger){z=v;if(a.data("horizontalScroll")){v=G.position().left*a.data("scrollAmount")}else{v=G.position().top*a.data("scrollAmount")}draggerSpeed=0}else{z=v/a.data("scrollAmount")}}else{if(typeof(v)==="string"){var c;if(v==="top"){c=0}else{if(v==="bottom"&&!a.data("horizontalScroll")){c=H.outerHeight()-A.height()}else{if(v==="left"){c=0}else{if(v==="right"&&a.data("horizontalScroll")){c=H.outerWidth()-A.width()}else{if(v==="first"){c=a.find(".mCSB_container").find(":first")}else{if(v==="last"){c=a.find(".mCSB_container").find(":last")}else{c=a.find(v)}}}}}}if(c.length===1){if(a.data("horizontalScroll")){v=c.position().left}else{v=c.position().top}z=v/a.data("scrollAmount")}else{z=v=c}}}if(a.data("horizontalScroll")){if(a.data("onTotalScrollBack_Offset")){D=-a.data("onTotalScrollBack_Offset")}if(a.data("onTotalScroll_Offset")){E=A.width()-H.outerWidth()+a.data("onTotalScroll_Offset")}if(z<0){z=v=0;clearInterval(a.data("mCSB_buttonScrollLeft"));if(!D){w=true}}else{if(z>=B.width()-G.width()){z=B.width()-G.width();v=A.width()-H.outerWidth();clearInterval(a.data("mCSB_buttonScrollRight"));if(!E){x=true}}else{v=-v}}g.mTweenAxis.call(this,G[0],"left",Math.round(z),draggerSpeed,F.scrollEasing);g.mTweenAxis.call(this,H[0],"left",Math.round(v),C,F.scrollEasing,{onStart:function(){if(F.callbacks&&!a.data("mCS_tweenRunning")){d("onScrollStart")}if(a.data("autoHideScrollbar")){g.showScrollbar.call(b)}},onUpdate:function(){if(F.callbacks){d("whileScrolling")}},onComplete:function(){if(F.callbacks){d("onScroll");if(w||(D&&H.position().left>=D)){d("onTotalScrollBack")}if(x||(E&&H.position().left<=E)){d("onTotalScroll")}}G.data("preventAction",false);a.data("mCS_tweenRunning",false);if(a.data("autoHideScrollbar")){if(!A.hasClass("mCS-mouse-over")){g.hideScrollbar.call(b)}}},})}else{if(a.data("onTotalScrollBack_Offset")){D=-a.data("onTotalScrollBack_Offset")}if(a.data("onTotalScroll_Offset")){E=A.height()-H.outerHeight()+a.data("onTotalScroll_Offset")}if(z<0){z=v=0;clearInterval(a.data("mCSB_buttonScrollUp"));if(!D){w=true}}else{if(z>=B.height()-G.height()){z=B.height()-G.height();v=A.height()-H.outerHeight();clearInterval(a.data("mCSB_buttonScrollDown"));if(!E){x=true}}else{v=-v}}g.mTweenAxis.call(this,G[0],"top",Math.round(z),draggerSpeed,F.scrollEasing);g.mTweenAxis.call(this,H[0],"top",Math.round(v),C,F.scrollEasing,{onStart:function(){if(F.callbacks&&!a.data("mCS_tweenRunning")){d("onScrollStart")}if(a.data("autoHideScrollbar")){g.showScrollbar.call(b)}},onUpdate:function(){if(F.callbacks){d("whileScrolling")}},onComplete:function(){if(F.callbacks){d("onScroll");if(w||(D&&H.position().top>=D)){d("onTotalScrollBack")}if(x||(E&&H.position().top<=E)){d("onTotalScroll")}}G.data("preventAction",false);a.data("mCS_tweenRunning",false);if(a.data("autoHideScrollbar")){if(!A.hasClass("mCS-mouse-over")){g.hideScrollbar.call(b)}}},})}if(a.data("mCS_Init")){a.data({mCS_Init:false})}}function d(i){this.mcs={top:H.position().top,left:H.position().left,draggerTop:G.position().top,draggerLeft:G.position().left,topPct:Math.round((100*Math.abs(H.position().top))/Math.abs(H.outerHeight()-A.height())),leftPct:Math.round((100*Math.abs(H.position().left))/Math.abs(H.outerWidth()-A.width()))};switch(i){case"onScrollStart":a.data("mCS_tweenRunning",true).data("onScrollStart_Callback").call(a,this.mcs);break;case"whileScrolling":a.data("whileScrolling_Callback").call(a,this.mcs);break;case"onScroll":a.data("onScroll_Callback").call(a,this.mcs);break;case"onTotalScrollBack":a.data("onTotalScrollBack_Callback").call(a,this.mcs);break;case"onTotalScroll":a.data("onTotalScroll_Callback").call(a,this.mcs);break}}},stop:function(){var a=h(this),c=a.children().children(".mCSB_container"),b=a.children().children().children().children(".mCSB_dragger");g.mTweenAxisStop.call(this,c[0]);g.mTweenAxisStop.call(this,b[0])},disable:function(l){var a=h(this),k=a.children(".mCustomScrollBox"),c=k.children(".mCSB_container"),d=k.children(".mCSB_scrollTools"),b=d.children().children(".mCSB_dragger");k.unbind("mousewheel focusin mouseenter mouseleave touchend");c.unbind("touchstart touchmove");if(l){if(a.data("horizontalScroll")){b.add(c).css("left",0)}else{b.add(c).css("top",0)}}d.css("display","none");c.addClass("mCS_no_scrollbar");a.data({bindEvent_mousewheel:false,bindEvent_focusin:false,bindEvent_content_touch:false,bindEvent_autoHideScrollbar:false}).addClass("mCS_disabled")},destroy:function(){var a=h(this);a.removeClass("mCustomScrollbar _mCS_"+a.data("mCustomScrollbarIndex")).addClass("mCS_destroyed").children().children(".mCSB_container").unwrap().children().unwrap().siblings(".mCSB_scrollTools").remove();h(document).unbind("mousemove."+a.data("mCustomScrollbarIndex")+" mouseup."+a.data("mCustomScrollbarIndex")+" MSPointerMove."+a.data("mCustomScrollbarIndex")+" MSPointerUp."+a.data("mCustomScrollbarIndex"));h(window).unbind("resize."+a.data("mCustomScrollbarIndex"))}},g={showScrollbar:function(){this.stop().animate({opacity:1},"fast")},hideScrollbar:function(){this.stop().animate({opacity:0},"fast")},mTweenAxis:function(N,L,M,O,F,a){var a=a||{},d=a.onStart||function(){},E=a.onUpdate||function(){},c=a.onComplete||function(){};var G=A(),I,K=0,C=N.offsetTop,B=N.style;if(L==="left"){C=N.offsetLeft}var H=M-C;D();P();function A(){if(window.performance&&window.performance.now){return window.performance.now()}else{if(window.performance&&window.performance.webkitNow){return window.performance.webkitNow()}else{if(Date.now){return Date.now()}else{return new Date().getTime()}}}}function b(){if(!K){d.call()}K=A()-G;z();if(K>=N._time){N._time=(K>N._time)?K+I-(K-N._time):K+I-1;if(N._time<K+1){N._time=K+1}}if(N._time<O){N._id=_request(b)}else{c.call()}}function z(){if(O>0){N.currVal=J(N._time,C,H,O,F);B[L]=Math.round(N.currVal)+"px"}else{B[L]=M+"px"}E.call()}function P(){I=1000/60;N._time=K+I;_request=(!window.requestAnimationFrame)?function(i){z();return setTimeout(i,0.01)}:window.requestAnimationFrame;N._id=_request(b)}function D(){if(N._id==null){return}if(!window.requestAnimationFrame){clearTimeout(N._id)}else{window.cancelAnimationFrame(N._id)}N._id=null}function J(o,i,j,k,n){switch(n){case"linear":return j*o/k+i;break;case"easeOutQuad":o/=k;return -j*o*(o-2)+i;break;case"easeInOutQuad":o/=k/2;if(o<1){return j/2*o*o+i}o--;return -j/2*(o*(o-2)-1)+i;break;case"easeOutCubic":o/=k;o--;return j*(o*o*o+1)+i;break;case"easeOutQuart":o/=k;o--;return -j*(o*o*o*o-1)+i;break;case"easeOutQuint":o/=k;o--;return j*(o*o*o*o*o+1)+i;break;case"easeOutCirc":o/=k;o--;return j*Math.sqrt(1-o*o)+i;break;case"easeOutSine":return j*Math.sin(o/k*(Math.PI/2))+i;break;case"easeOutExpo":return j*(-Math.pow(2,-10*o/k)+1)+i;break;case"mcsEaseOut":var l=(o/=k)*o,m=l*o;return i+j*(0.499999999999997*m*l+-2.5*l*l+5.5*m+-6.5*l+4*o);break;case"draggerRailEase":o/=k/2;if(o<1){return j/2*o*o*o+i}o-=2;return j/2*(o*o*o+2)+i;break}}},mTweenAxisStop:function(a){if(a._id==null){return}if(!window.requestAnimationFrame){clearTimeout(a._id)}else{window.cancelAnimationFrame(a._id)}a._id=null},rafPolyfill:function(){var a=["ms","moz","webkit","o"],b=a.length;while(--b>-1&&!window.requestAnimationFrame){window.requestAnimationFrame=window[a[b]+"RequestAnimationFrame"];window.cancelAnimationFrame=window[a[b]+"CancelAnimationFrame"]||window[a[b]+"CancelRequestAnimationFrame"]}}};g.rafPolyfill.call();h.support.touch=!!("ontouchstart" in window);h.support.msPointer=window.navigator.msPointerEnabled;var f=("https:"==document.location.protocol)?"https:":"http:";h.event.special.mousewheel||document.write('<script src="'+f+'//cdnjs.cloudflare.com/ajax/libs/jquery-mousewheel/3.0.6/jquery.mousewheel.min.js"><\/script>');h.fn.mCustomScrollbar=function(a){if(e[a]){return e[a].apply(this,Array.prototype.slice.call(arguments,1))}else{if(typeof a==="object"||!a){return e.init.apply(this,arguments)}else{h.error("Method "+a+" does not exist")}}}})(jQuery);